import { CurrencyPipe, DatePipe } from '@angular/common';
import {
  HTTP_INTERCEPTORS,
  HttpClient,
  provideHttpClient,
  withFetch,
  withInterceptorsFromDi,
} from '@angular/common/http';
import { ApplicationConfig, importProvidersFrom, provideZoneChangeDetection } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { provideAnimations } from '@angular/platform-browser/animations';
import { provideRouter, withInMemoryScrolling } from '@angular/router';

import { TranslateLoader, TranslateModule } from '@ngx-translate/core';
import { NgxsStoragePluginModule } from '@ngxs/storage-plugin';
import { NgxsModule } from '@ngxs/store';
import { ToastrModule } from 'ngx-toastr';

import { routes } from './app.routes';
import { AuthInterceptor } from './core/interceptors/auth.interceptor';
import { GlobalErrorHandlerInterceptor } from './core/interceptors/globle-error-handler.interceptor';
import { LoaderInterceptor } from './core/interceptors/loader.interceptor';
import { TranslationLoader } from './shared/services/translation-loader.service';
import { AccountState } from './shared/state/account.state';
import { AttachmentState } from './shared/state/attachment.state';
import { AttributeState } from './shared/state/attribute.state';
import { AuthState } from './shared/state/auth.state';
import { AuthorState } from './shared/state/author.state';
import { BlogState } from './shared/state/blog.state';
import { BrandState } from './shared/state/brand.state';
import { CartState } from './shared/state/cart.state';
import { CategoryState } from './shared/state/category.state';
import { CommissionState } from './shared/state/commission.state';
import { CountryState } from './shared/state/country.state';
import { CouponState } from './shared/state/coupon.state';
import { CurrencyState } from './shared/state/currency.state';
import { DashboardState } from './shared/state/dashboard.state';
import { FaqState } from './shared/state/faq.state';
import { LanguageState } from './shared/state/language.state';
import { LicenseKeysState } from './shared/state/license-key.state';
import { LoaderState } from './shared/state/loader.state';
import { MenuState } from './shared/state/menu.state';
import { NoticeState } from './shared/state/notice.state';
import { NotificationState } from './shared/state/notification.state';
import { OrderStatusState } from './shared/state/order-status.state';
import { OrderState } from './shared/state/order.state';
import { PageState } from './shared/state/page.state';
import { PaymentDetailsState } from './shared/state/payment-details.state';
import { PointState } from './shared/state/point.state';
import { ProductState } from './shared/state/product.state';
import { PublicationState } from './shared/state/publication.state';
import { QuestionAnswersState } from './shared/state/questions-answers.state';
import { RefundState } from './shared/state/refund.state';
import { ReportsState } from './shared/state/reports.state';
import { ReviewState } from './shared/state/review.state';
import { RoleState } from './shared/state/role.state';
import { SettingState } from './shared/state/setting.state';
import { ShippingState } from './shared/state/shipping.state';
import { SidebarState } from './shared/state/sidebar.state';
import { StateState } from './shared/state/state.state';
import { StoreState } from './shared/state/store.state';
import { SubscriptionState } from './shared/state/subscription.state';
import { TagState } from './shared/state/tag.state';
import { TaxState } from './shared/state/tax.state';
import { ThemeOptionState } from './shared/state/theme-option.state';
import { ThemeState } from './shared/state/theme.state';
import { UserState } from './shared/state/user.state';
import { VendorWalletState } from './shared/state/vendor-wallet.state';
import { WalletState } from './shared/state/wallet.state';
import { WithdrawalState } from './shared/state/withdrawal.state';
import { ZoneState } from './shared/state/zone.state';

export function HttpLoaderFactory(_http: HttpClient) {
  return new TranslationLoader();
}

export const appConfig: ApplicationConfig = {
  providers: [
    provideZoneChangeDetection({ eventCoalescing: true }),
    provideRouter(
      routes,
      withInMemoryScrolling({
        scrollPositionRestoration: 'top',
      }),
    ),
    CurrencyPipe,
    DatePipe,
    provideAnimations(),
    importProvidersFrom(
      FormsModule,
      ReactiveFormsModule,
      NgxsModule.forRoot([
        AccountState,
        AttachmentState,
        AttributeState,
        AuthState,
        BlogState,
        BrandState,
        CartState,
        CategoryState,
        CommissionState,
        CountryState,
        CouponState,
        CurrencyState,
        DashboardState,
        FaqState,
        LanguageState,
        LicenseKeysState,
        LoaderState,
        MenuState,
        NoticeState,
        NotificationState,
        OrderStatusState,
        OrderState,
        PageState,
        PaymentDetailsState,
        PointState,
        ProductState,
        QuestionAnswersState,
        RefundState,
        ReviewState,
        RoleState,
        SettingState,
        ShippingState,
        SidebarState,
        StateState,
        StoreState,
        SubscriptionState,
        TagState,
        TaxState,
        ThemeOptionState,
        ThemeState,
        UserState,
        VendorWalletState,
        WalletState,
        WithdrawalState,
        ReportsState,
        ZoneState,
        AuthorState,
        PublicationState,
      ]),
      NgxsStoragePluginModule.forRoot({
        keys: [
          'auth',
          'dashboard',
          'notification',
          'account',
          'country',
          'state',
          'setting',
          'language',
        ],
      }),
      TranslateModule.forRoot({
        loader: {
          provide: TranslateLoader,
          useFactory: HttpLoaderFactory,
          deps: [HttpClient],
        },
      }),
      ToastrModule.forRoot({
        positionClass: 'toast-top-center',
        preventDuplicates: true,
      }),
    ),
    provideHttpClient(withInterceptorsFromDi(), withFetch()),
    {
      provide: HTTP_INTERCEPTORS,
      useClass: AuthInterceptor,
      multi: true,
    },
    {
      provide: HTTP_INTERCEPTORS,
      useClass: LoaderInterceptor,
      multi: true,
    },
    {
      provide: HTTP_INTERCEPTORS,
      useClass: GlobalErrorHandlerInterceptor,
      multi: true,
    },
  ],
};
