import { Routes } from '@angular/router';

import { AuthGuard } from './core/guard/auth.guard';
import { SettingResolver } from './shared/resolver/setting.resolver';
import { full } from './shared/routes/full.routes';
import { content } from './shared/routes/routes';

export const routes: Routes = [
  {
    path: '',
    redirectTo: 'auth/login',
    pathMatch: 'full',
  },
  {
    path: 'auth',
    loadChildren: () => import('./components/auth/auth.routes').then(r => r.auth),
    canActivateChild: [AuthGuard],
  },
  {
    path: '',
    loadComponent: () => import('./shared/components/layout/content/content').then(m => m.Content),
    children: content,
    canActivate: [AuthGuard],
    resolve: {
      data: SettingResolver,
    },
  },
  {
    path: '',
    loadComponent: () => import('./shared/components/layout/full/full').then(m => m.Full),
    children: full,
  },
  {
    path: '**',
    pathMatch: 'full',
    loadComponent: () => import('./errors/error404/error404').then(m => m.Error404),
  },
];
