import { Routes } from '@angular/router';

import { Attribute } from './attribute';
import { CreateAttribute } from './create-attribute/create-attribute';
import { EditAttribute } from './edit-attribute/edit-attribute';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Attribute,
    canActivate: [PermissionGuard],
    data: {
      permission: 'attribute.index',
    },
  },
  {
    path: 'create',
    component: CreateAttribute,
    canActivate: [PermissionGuard],
    data: {
      permission: ['attribute.index', 'attribute.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditAttribute,
    canActivate: [PermissionGuard],
    data: {
      permission: ['attribute.index', 'attribute.edit'],
    },
  },
] as Routes;
