import { Routes } from '@angular/router';

// Permission Guard
import { Author } from './author';
import { CreateAuthor } from './create-author/create-author';
import { EditAuthor } from './edit-author/edit-author';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Author,
    canActivate: [PermissionGuard],
    data: {
      permission: 'author.index',
    },
  },
  {
    path: 'create',
    component: CreateAuthor,
    canActivate: [PermissionGuard],
    data: {
      permission: ['author.index', 'author.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditAuthor,
    canActivate: [PermissionGuard],
    data: {
      permission: ['author.index', 'author.edit'],
    },
  },
] as Routes;
