import { Routes } from '@angular/router';

import { Blog } from './blog';
import { BlogCategory } from './category/blog-category/blog-category';
import { EditBlogCategory } from './category/edit-blog-category/edit-blog-category';
import { CreateBlog } from './create-blog/create-blog';
import { EditBlog } from './edit-blog/edit-blog';
import { BlogTag } from './tag/blog-tag/blog-tag';
import { CreateBlogTag } from './tag/create-blog-tag/create-blog-tag';
import { EditBlogTag } from './tag/edit-blog-tag/edit-blog-tag';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Blog,
    canActivate: [PermissionGuard],
    data: {
      permission: 'blog.index',
    },
  },
  {
    path: 'create',
    component: CreateBlog,
    canActivate: [PermissionGuard],
    data: {
      permission: ['blog.index', 'blog.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditBlog,
    canActivate: [PermissionGuard],
    data: {
      permission: ['blog.index', 'blog.edit'],
    },
  },
  {
    path: 'category',
    component: BlogCategory,
    canActivate: [PermissionGuard],
    data: {
      permission: ['category.index'],
    },
  },
  {
    path: 'category/:lang/edit/:id',
    component: EditBlogCategory,
    canActivate: [PermissionGuard],
    data: {
      permission: ['category.index', 'category.create'],
    },
  },
  {
    path: 'tag',
    component: BlogTag,
    canActivate: [PermissionGuard],
    data: {
      permission: ['tag.index'],
    },
  },
  {
    path: 'tag/create',
    component: CreateBlogTag,
    canActivate: [PermissionGuard],
    data: {
      permission: ['tag.create'],
    },
  },
  {
    path: 'tag/:lang/edit/:id',
    component: EditBlogTag,
    canActivate: [PermissionGuard],
    data: {
      permission: ['tag.edit'],
    },
  },
] as Routes;
