import { Routes } from '@angular/router';

import { Brand } from './brand';
import { CreateBrand } from './create-brand/create-brand';
import { EditBrand } from './edit-brand/edit-brand';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Brand,
    canActivate: [PermissionGuard],
    data: {
      permission: 'brand.index',
    },
  },
  {
    path: 'create',
    component: CreateBrand,
    canActivate: [PermissionGuard],
    data: {
      permission: ['brand.index', 'brand.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditBrand,
    canActivate: [PermissionGuard],
    data: {
      permission: ['brand.index', 'brand.edit'],
    },
  },
] as Routes;
