import { Routes } from '@angular/router';

import { Category } from './category';
import { EditCategory } from './edit-category/edit-category';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Category,
    canActivate: [PermissionGuard],
    data: {
      permission: 'category.index',
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditCategory,
    canActivate: [PermissionGuard],
    data: {
      permission: ['category.index', 'category.edit'],
    },
  },
] as Routes;
