import { AsyncPipe } from '@angular/common';
import { Component, inject, Input, viewChild } from '@angular/core';
import { Router } from '@angular/router';

import {
  NgbDropdown,
  NgbDropdownButtonItem,
  NgbDropdownItem,
  NgbDropdownMenu,
  NgbDropdownToggle,
} from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { FormCategory } from './form-category/form-category';
import { Tree } from './tree/tree';
import { ExportCategoryAction, GetCategoriesAction } from '../../shared/action/category.action';
import { PageWrapper } from '../../shared/components/page-wrapper/page-wrapper';
import { ImportCsvModal } from '../../shared/components/ui/modal/import-csv-modal/import-csv-modal';
import { HasPermissionDirective } from '../../shared/directive/has-permission.directive';
import { ICategoryModel } from '../../shared/interface/category.interface';
import { CategoryState } from '../../shared/state/category.state';

@Component({
  selector: 'app-category',
  templateUrl: './category.html',
  styleUrls: ['./category.scss'],
  imports: [
    PageWrapper,
    HasPermissionDirective,
    NgbDropdown,
    NgbDropdownToggle,
    NgbDropdownMenu,
    NgbDropdownButtonItem,
    NgbDropdownItem,
    Tree,
    FormCategory,
    ImportCsvModal,
    AsyncPipe,
    TranslateModule,
  ],
})
export class Category {
  private store = inject(Store);
  private router = inject(Router);

  category$: Observable<ICategoryModel> = inject(Store).select(
    CategoryState.category,
  ) as Observable<ICategoryModel>;

  readonly CSVModal = viewChild<ImportCsvModal>('csvModal');

  @Input() type: string = 'create';
  @Input() categoryType: string | null = 'product';

  ngOnInit(): void {
    this.store.dispatch(new GetCategoriesAction({ type: this.categoryType }));
  }

  export() {
    this.store.dispatch(new ExportCategoryAction());
  }

  create(type: string) {
    void this.router.navigate([type == 'post' ? '/blog/category' : '/category']);
  }
}
