import { Component, Input, inject, input, viewChild } from '@angular/core';
import { Router, ActivatedRoute, RouterLink } from '@angular/router';

import { Store } from '@ngxs/store';

import { DeleteCategoryAction } from '../../../../shared/action/category.action';
import { DeleteModal } from '../../../../shared/components/ui/modal/delete-modal/delete-modal';
import { HasPermissionDirective } from '../../../../shared/directive/has-permission.directive';
import { ICategory } from '../../../../shared/interface/category.interface';

@Component({
  selector: 'app-tree-node',
  templateUrl: './tree-node.html',
  styleUrls: ['./tree-node.scss'],
  imports: [HasPermissionDirective, RouterLink, DeleteModal],
})
export class TreeNode {
  private store = inject(Store);
  private router = inject(Router);
  private route = inject(ActivatedRoute);

  @Input() node: any;
  @Input() recursionKey: string;
  readonly displayKey = input<string>();
  readonly categoryType = input<string | null>('product');

  readonly DeleteModal = viewChild<DeleteModal>('deleteModal');

  public showChildrenNode: boolean = true;
  public id: number;

  ngOnInit() {
    this.route.params.subscribe(params => (this.id = params['id']));
  }

  edit(node: any) {
    const lang = this.store.selectSnapshot(state => state.language.localLanguage.locale);
    void this.router.navigateByUrl(
      `${node.type == 'post' ? `/blog/category/${lang}/edit` : `/category/${lang}/edit`}/${node?.id}`,
    );
  }

  delete(_actionType: string, data: ICategory) {
    this.store.dispatch(new DeleteCategoryAction(data.id!, data.type)).subscribe({
      complete: () => {
        if (data.type == 'post') void this.router.navigateByUrl('/blog/category');
        else void this.router.navigateByUrl('/category');
      },
    });
  }
}
