import { Routes } from '@angular/router';

import { Coupon } from './coupon';
import { CreateCoupon } from './create-coupon/create-coupon';
import { EditCoupon } from './edit-coupon/edit-coupon';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Coupon,
    canActivate: [PermissionGuard],
    data: {
      permission: 'coupon.index',
    },
  },
  {
    path: 'create',
    component: CreateCoupon,
    canActivate: [PermissionGuard],
    data: {
      permission: ['coupon.index', 'coupon.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditCoupon,
    canActivate: [PermissionGuard],
    data: {
      permission: ['coupon.index', 'coupon.edit'],
    },
  },
] as Routes;
