import { Routes } from '@angular/router';

import { CreateCurrency } from './create-currency/create-currency';
import { Currency } from './currency';
import { EditCurrency } from './edit-currency/edit-currency';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Currency,
    canActivate: [PermissionGuard],
    data: {
      permission: 'currency.index',
    },
  },
  {
    path: 'create',
    component: CreateCurrency,
    canActivate: [PermissionGuard],
    data: {
      permission: ['currency.index', 'currency.create'],
    },
  },
  {
    path: 'edit/:id',
    component: EditCurrency,
    canActivate: [PermissionGuard],
    data: {
      permission: ['currency.index', 'currency.edit'],
    },
  },
] as Routes;
