import { Routes } from '@angular/router';

import { CreateFaq } from './create-faq/create-faq';
import { EditFaq } from './edit-faq/edit-faq';
import { Faq } from './faq';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Faq,
    canActivate: [PermissionGuard],
    data: {
      permission: 'faq.index',
    },
  },
  {
    path: 'create',
    component: CreateFaq,
    canActivate: [PermissionGuard],
    data: {
      permission: ['faq.index', 'faq.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditFaq,
    canActivate: [PermissionGuard],
    data: {
      permission: ['faq.index', 'faq.edit'],
    },
  },
] as Routes;
