import { Routes } from '@angular/router';

import { CreateLanguage } from './create-language/create-language';
import { EditLanguage } from './edit-language/edit-language';
import { FormEditFile } from './form-edit-file/form-edit-file';
import { Language } from './language';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Language,
    canActivate: [PermissionGuard],
    // data: {
    //   permission: 'faq.index'
    // }
  },
  {
    path: 'create',
    component: CreateLanguage,
    canActivate: [PermissionGuard],
    // data: {
    //   permission: ['faq.index', 'faq.create']
    // }
  },
  {
    path: 'edit/:id',
    component: EditLanguage,
    canActivate: [PermissionGuard],
    // data: {
    //   permission: ['faq.index', 'faq.edit']
    // }
  },
  {
    path: 'edit-file/:id',
    component: FormEditFile,
    canActivate: [PermissionGuard],
    // data: {
    //   permission: ['faq.index', 'faq.edit']
    // }
  },
] as Routes;
