import { Routes } from '@angular/router';

import { CreateLicenseKey } from './create-license-key/create-license-key';
import { EditLicenseKey } from './edit-license-key/edit-license-key';
import { LicenseKey } from './license-key';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: LicenseKey,
    canActivate: [PermissionGuard],
    data: {
      permission: 'license_key.index',
    },
  },
  {
    path: 'create',
    component: CreateLicenseKey,
    canActivate: [PermissionGuard],
    data: {
      permission: ['license_key.index', 'license_key.create'],
    },
  },
  {
    path: 'edit/:id',
    component: EditLicenseKey,
    canActivate: [PermissionGuard],
    data: {
      permission: ['license_key.index', 'license_key.edit'],
    },
  },
] as Routes;
