import { Routes } from '@angular/router';

import { EditMenu } from './edit-menu/edit-menu';
import { Menu } from './menu';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Menu,
    canActivate: [PermissionGuard],
    data: {
      permission: 'menu.index',
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditMenu,
    canActivate: [PermissionGuard],
    data: {
      permission: ['menu.index', 'menu.edit'],
    },
  },
] as Routes;
