import { Routes } from '@angular/router';

import { CreateNotice } from './create-notice/create-notice';
import { EditNotice } from './edit-notice/edit-notice';
import { Notice } from './notice';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Notice,
    canActivate: [PermissionGuard],
    data: {
      permission: 'notice.index',
    },
  },
  {
    path: 'create',
    component: CreateNotice,
    canActivate: [PermissionGuard],
    data: {
      permission: ['notice.index', 'notice.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditNotice,
    canActivate: [PermissionGuard],
    data: {
      permission: ['notice.index', 'notice.edit'],
    },
  },
] as Routes;
