import { AsyncPipe, DatePipe } from '@angular/common';
import { Component, inject } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import {
  GetNotificationAction,
  MarkAsReadNotificationAction,
} from '../../shared/action/notification.action';
import { PageWrapper } from '../../shared/components/page-wrapper/page-wrapper';
import { INotification } from '../../shared/interface/notification.interface';
import { NotificationState } from '../../shared/state/notification.state';

@Component({
  selector: 'app-notification',
  templateUrl: './notification.html',
  styleUrls: ['./notification.scss'],
  imports: [PageWrapper, AsyncPipe, DatePipe],
})
export class Notification {
  private store = inject(Store);

  notification$: Observable<INotification[]> = inject(Store).select(NotificationState.notification);

  constructor() {
    this.store.dispatch(new GetNotificationAction());
  }

  ngOnDestroy() {
    this.store.dispatch(new MarkAsReadNotificationAction());
  }
}
