import { Routes } from '@angular/router';

import { Checkout } from './checkout/checkout';
import { CreateOrder } from './create-order/create-order';
import { Details } from './details/details';
import { Order } from './order';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Order,
    canActivate: [PermissionGuard],
    data: {
      permission: 'order.index',
    },
  },
  {
    path: 'details/:id',
    component: Details,
    canActivate: [PermissionGuard],
    data: {
      permission: 'order.index',
    },
  },
  {
    path: 'create',
    component: CreateOrder,
    canActivate: [PermissionGuard],
    data: {
      permission: ['order.index', 'order.create'],
    },
  },
  {
    path: 'checkout',
    component: Checkout,
    canActivate: [PermissionGuard],
    data: {
      permission: ['order.index', 'order.create'],
    },
  },
] as Routes;
