import { Routes } from '@angular/router';

import { CreatePage } from './create-page/create-page';
import { EditPage } from './edit-page/edit-page';
import { Page } from './page';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Page,
    canActivate: [PermissionGuard],
    data: {
      permission: 'page.index',
    },
  },
  {
    path: 'create',
    component: CreatePage,
    canActivate: [PermissionGuard],
    data: {
      permission: ['page.index', 'page.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditPage,
    canActivate: [PermissionGuard],
    data: {
      permission: ['page.index', 'page.edit'],
    },
  },
] as Routes;
