import { Routes } from '@angular/router';

import { CreateProduct } from './create-product/create-product';
import { EditProduct } from './edit-product/edit-product';
import { Product } from './product';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Product,
    canActivate: [PermissionGuard],
    data: {
      permission: 'product.index',
    },
  },
  {
    path: 'create',
    component: CreateProduct,
    canActivate: [PermissionGuard],
    data: {
      permission: ['product.index', 'product.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditProduct,
    canActivate: [PermissionGuard],
    data: {
      permission: ['product.index', 'product.edit'],
    },
  },
] as Routes;
