import { Routes } from '@angular/router';

import { CreatePublication } from './create-publication/create-publication';
import { EditPublication } from './edit-publication/edit-publication';
import { Publication } from './publication';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Publication,
    canActivate: [PermissionGuard],
    data: {
      permission: 'publication.index',
    },
  },
  {
    path: 'create',
    component: CreatePublication,
    canActivate: [PermissionGuard],
    data: {
      permission: ['publication.index', 'publication.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditPublication,
    canActivate: [PermissionGuard],
    data: {
      permission: ['publication.index', 'publication.edit'],
    },
  },
] as Routes;
