import { Routes } from '@angular/router';

import { CreateRole } from './create-role/create-role';
import { EditRole } from './edit-role/edit-role';
import { Role } from './role';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Role,
    canActivate: [PermissionGuard],
    data: {
      permission: 'role.index',
    },
  },
  {
    path: 'create',
    component: CreateRole,
    canActivate: [PermissionGuard],
    data: {
      permission: ['role.index', 'role.create'],
    },
  },
  {
    path: 'edit/:id',
    component: EditRole,
    canActivate: [PermissionGuard],
    data: {
      permission: ['role.index', 'role.edit'],
    },
  },
] as Routes;
