import { Routes } from '@angular/router';

import { Shipping } from './shipping';
import { ShippingCountry } from './shipping-country/shipping-country';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Shipping,
    canActivate: [PermissionGuard],
    data: {
      permission: 'shipping.index',
    },
  },
  {
    path: 'edit/:id',
    component: ShippingCountry,
    canActivate: [PermissionGuard],
    data: {
      permission: ['shipping.index', 'shipping.edit'],
    },
  },
] as Routes;
