import { Routes } from '@angular/router';

import { CreateStoreAction } from './create-store/create-store';
import { EditStore } from './edit-store/edit-store';
import { Stores } from './stores';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Stores,
    canActivate: [PermissionGuard],
    data: {
      permission: 'store.index',
    },
  },
  {
    path: 'create',
    component: CreateStoreAction,
    canActivate: [PermissionGuard],
    data: {
      permission: ['store.index', 'store.create'],
    },
  },
  {
    path: 'edit/:id',
    component: EditStore,
    canActivate: [PermissionGuard],
    data: {
      permission: ['store.index', 'store.edit'],
    },
  },
] as Routes;
