import { Routes } from '@angular/router';

import { CreateTag } from './create-tag/create-tag';
import { EditTag } from './edit-tag/edit-tag';
import { Tag } from './tag';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Tag,
    canActivate: [PermissionGuard],
    data: {
      permission: 'tag.index',
    },
  },
  {
    path: 'create',
    component: CreateTag,
    canActivate: [PermissionGuard],
    data: {
      permission: ['tag.index', 'tag.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditTag,
    canActivate: [PermissionGuard],
    data: {
      permission: ['tag.index', 'tag.edit'],
    },
  },
] as Routes;
