import { Routes } from '@angular/router';

import { CreateTax } from './create-tax/create-tax';
import { EditTax } from './edit-tax/edit-tax';
import { Tax } from './tax';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Tax,
    canActivate: [PermissionGuard],
    data: {
      permission: 'tax.index',
    },
  },
  {
    path: 'create',
    component: CreateTax,
    canActivate: [PermissionGuard],
    data: {
      permission: ['tax.index', 'tax.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditTax,
    canActivate: [PermissionGuard],
    data: {
      permission: ['tax.index', 'tax.edit'],
    },
  },
] as Routes;
