import { Routes } from '@angular/router';

import { Berlin } from './berlin/berlin';
import { Cairo } from './cairo/cairo';
import { Denver } from './denver/denver';
import { Madrid } from './madrid/madrid';
import { Moscow } from './moscow/moscow';
import { Osaka } from './osaka/osaka';
import { Paris } from './paris/paris';
import { Rome } from './rome/rome';
import { Theme } from './theme';
import { Tokyo } from './tokyo/tokyo';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Theme,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/paris',
    component: Paris,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/tokyo',
    component: Tokyo,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/osaka',
    component: Osaka,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/rome',
    component: Rome,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/madrid',
    component: Madrid,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/berlin',
    component: Berlin,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/denver',
    component: Denver,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/moscow',
    component: Moscow,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
  {
    path: ':lang/cairo',
    component: Cairo,
    canActivate: [PermissionGuard],
    data: {
      permission: 'theme.index',
    },
  },
] as Routes;
