import { Routes } from '@angular/router';

import { CreateUserAction } from './create-user/create-user';
import { EditUser } from './edit-user/edit-user';
import { User } from './user';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: User,
    canActivate: [PermissionGuard],
    data: {
      permission: 'user.index',
    },
  },
  {
    path: 'create',
    component: CreateUserAction,
    canActivate: [PermissionGuard],
    data: {
      permission: ['user.index', 'user.create'],
    },
  },
  {
    path: 'edit/:id',
    component: EditUser,
    canActivate: [PermissionGuard],
    data: {
      permission: ['user.index', 'user.edit'],
    },
  },
] as Routes;
