import { Routes } from '@angular/router';

// Permission Guard
import { CreateZone } from './create-zone/create-zone';
import { EditZone } from './edit-zone/edit-zone';
import { Zone } from './zone';
import { PermissionGuard } from '../../core/guard/permission.guard';

export default [
  {
    path: '',
    component: Zone,
    canActivate: [PermissionGuard],
    data: {
      permission: 'user.index',
    },
  },
  {
    path: 'create',
    component: CreateZone,
    canActivate: [PermissionGuard],
    data: {
      permission: ['user.index', 'user.create'],
    },
  },
  {
    path: ':lang/edit/:id',
    component: EditZone,
    canActivate: [PermissionGuard],
    data: {
      permission: ['user.index', 'user.edit'],
    },
  },
] as Routes;
