import { Injectable, inject } from '@angular/core';
import { ActivatedRouteSnapshot, Router, RouterStateSnapshot, UrlTree } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable, of } from 'rxjs';
import { catchError, map, take } from 'rxjs/operators';

import { IPermission } from '../../shared/interface/role.interface';

@Injectable({
  providedIn: 'root',
})
export class PermissionGuard {
  private store = inject(Store);
  router = inject(Router);

  canActivate(
    route: ActivatedRouteSnapshot,
    _state: RouterStateSnapshot,
  ): Observable<boolean | UrlTree> | Promise<boolean | UrlTree> | boolean | UrlTree {
    const requiredPermission = route.data?.['permission'];

    return this.store
      .select(state => state.account?.permissions)
      .pipe(
        take(1), // Only take the first emission to prevent multiple evaluations
        map((permissions: IPermission[]) => permissions?.map(value => value?.name) || []),
        map(permissions => {
          // If no permission is required, allow access
          if (!requiredPermission) {
            return true;
          }

          // Check if the required permissions match
          if (
            (!Array.isArray(requiredPermission) && permissions.includes(requiredPermission)) ||
            (Array.isArray(requiredPermission) &&
              requiredPermission.every(action => permissions.includes(action)))
          ) {
            return true;
          } else {
            void this.router.navigate(['/error/403']);
            return false;
          }
        }),
        catchError(() => {
          void this.router.navigate(['/error/403']);
          return of(false);
        }),
      );
  }
}
