import { IAuthor } from '../interface/author.interface';
import { Params } from '../interface/core.interface';

export class GetAuthorsAction {
  static readonly type = '[Author] Get';
  constructor(public payload?: Params) {}
}

export class CreateAuthorAction {
  static readonly type = '[Author] Create';
  constructor(public payload: IAuthor) {}
}

export class EditAuthorAction {
  static readonly type = '[Author] Edit';
  constructor(public id: number) {}
}

export class UpdateAuthorAction {
  static readonly type = '[Author] Update';
  constructor(
    public payload: IAuthor,
    public id: number,
  ) {}
}

export class UpdateAuthorStatusAction {
  static readonly type = '[Author] Update Status';
  constructor(
    public id: number,
    public status: boolean,
  ) {}
}

export class DeleteAuthorAction {
  static readonly type = '[Author] Delete';
  constructor(public id: number) {}
}

export class DeleteAllAuthorAction {
  static readonly type = '[Author] Delete All';
  constructor(public ids: number[]) {}
}
