import { Params } from '../interface/core.interface';
import { ILanguage } from '../interface/language.interface';

export class GetLanguageAction {
  static readonly type = '[Language] Get';
  constructor(public payload?: Params) {}
}

export class CreateLanguageAction {
  static readonly type = '[Language] Create';
  constructor(public payload: ILanguage) {}
}

export class EditLanguageAction {
  static readonly type = '[Language] Edit';
  constructor(public id: number) {}
}

export class UpdateLanguageAction {
  static readonly type = '[Language] Update';
  constructor(
    public payload: ILanguage,
    public id: number,
  ) {}
}

export class UpdateLanguageStatusAction {
  static readonly type = '[Language] Update Status';
  constructor(
    public id: number,
    public status: boolean,
  ) {}
}

export class DeleteLanguageAction {
  static readonly type = '[Language] Delete';
  constructor(public id: number) {}
}

export class EditFormLanguageAction {
  static readonly type = '[Language] Form';
  constructor(public lang: string) {}
}

export class LocalLanguageAction {
  static readonly type = '[Language] Local Language';
  constructor(public language: ILanguage) {}
}

export class GetLanguageFilesAction {
  static readonly type = '[FileLanguage] Get';
}

export class GetLanguageFilesFieldsAction {
  static readonly type = '[FileLanguage Fields] Get';
  constructor(
    public file: string,
    public params?: Params,
  ) {}
}

export class UpdateLanguageFilesFieldsAction {
  static readonly type = '[FileLanguage Fields] Update';
  constructor(
    public file: string,
    public payload: any,
    public params?: Params,
  ) {}
}
