import { Params } from '../interface/core.interface';
import { IPublication } from '../interface/publication.interface';

export class GetPublicationsAction {
  static readonly type = '[Publication] Get';
  constructor(public payload?: Params) {}
}

export class CreatePublicationAction {
  static readonly type = '[Publication] Create';
  constructor(public payload: IPublication) {}
}

export class EditPublicationAction {
  static readonly type = '[Publication] Edit';
  constructor(public id: number) {}
}

export class UpdatePublicationAction {
  static readonly type = '[Publication] Update';
  constructor(
    public payload: IPublication,
    public id: number,
  ) {}
}

export class UpdatePublicationStatusAction {
  static readonly type = '[Publication] Update Status';
  constructor(
    public id: number,
    public status: boolean,
  ) {}
}

export class DeletePublicationAction {
  static readonly type = '[Publication] Delete';
  constructor(public id: number) {}
}

export class DeleteAllPublicationAction {
  static readonly type = '[Publication] Delete All';
  constructor(public ids: number[]) {}
}
