import { Params } from '../interface/core.interface';
import { IZone } from '../interface/zone.interface';

export class GetZonesAction {
  static readonly type = '[Zone] Get';
  constructor(public payload?: Params) {}
}

export class CreateZoneAction {
  static readonly type = '[Zone] Create';
  constructor(public payload: IZone) {}
}

export class EditZoneAction {
  static readonly type = '[Zone] Edit';
  constructor(public id: number) {}
}

export class UpdateZoneAction {
  static readonly type = '[Zone] Update';
  constructor(
    public payload: IZone,
    public id: number,
  ) {}
}

export class UpdateZoneStatusAction {
  static readonly type = '[Zone] Update Status';
  constructor(
    public id: number,
    public status: boolean,
  ) {}
}

export class DeleteZoneAction {
  static readonly type = '[Zone] Delete';
  constructor(public id: number) {}
}

export class DeleteAllZoneAction {
  static readonly type = '[Zone] Delete All';
  constructor(public ids: number[]) {}
}
