import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';
import { Router } from '@angular/router';

import { TranslateService } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { EditFormLanguageAction, LocalLanguageAction } from '../../../../action/language.action';
import { ILanguage, ILanguageModel } from '../../../../interface/language.interface';
import { IValues } from '../../../../interface/setting.interface';
import { TranslationLoader } from '../../../../services/translation-loader.service';
import { LanguageState } from '../../../../state/language.state';
import { SettingState } from '../../../../state/setting.state';
import { Button } from '../../../ui/button/button';

@Component({
  selector: 'app-languages',
  imports: [CommonModule, Button],
  templateUrl: './languages.html',
  styleUrls: ['./languages.scss'],
})
export class Languages {
  private translate = inject(TranslateService);
  translationLoader = inject(TranslationLoader);
  store = inject(Store);
  router = inject(Router);

  public active: boolean = false;
  public selectedLanguage: ILanguage;

  setting$: Observable<IValues | null> = inject(Store).select(SettingState.setting);
  language$: Observable<ILanguageModel> = inject(Store).select(LanguageState.language);

  constructor() {
    this.setting$.subscribe(value => {
      if (value) {
        this.selectedLanguage = value?.general?.default_language!;
      }
    });
  }

  selectLanguage(language: ILanguage) {
    this.active = false;
    this.translate.use(language.name);
    this.selectedLanguage = language;
    this.store.dispatch(new EditFormLanguageAction(language?.locale));
    this.store.dispatch(new LocalLanguageAction(language));
    this.translationLoader.getTranslation();
    location.reload();
  }

  clickHeaderOnMobile() {
    this.active = !this.active;
  }

  hideDropdown() {
    this.active = false;
  }
}
