import { Component, inject } from '@angular/core';
import { NavigationEnd, Router, RouterModule } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetLanguageAction } from '../../../action/language.action';
import { ILanguage, ILanguageModel } from '../../../interface/language.interface';
import { NavService } from '../../../services/nav.service';
import { LanguageState } from '../../../state/language.state';
import { Footer } from '../../footer/footer';
import { Header } from '../../header/header';
import { Sidebar } from '../../sidebar/sidebar';
import { SidebarMenuSkeleton } from '../../ui/modal/skeleton/sidebar-menu-skeleton/sidebar-menu-skeleton';

@Component({
  selector: 'app-content',
  imports: [Header, Footer, RouterModule, Header, SidebarMenuSkeleton, Sidebar],
  templateUrl: './content.html',
  styleUrls: ['./content.scss'],
})
export class Content {
  public navServices = inject(NavService);
  private router = inject(Router);
  private store = inject(Store);

  language$: Observable<ILanguageModel> = inject(Store).select(LanguageState.language);

  public selectedLang: ILanguage;

  constructor() {
    this.store.dispatch(new GetLanguageAction()).subscribe({
      next: _val => {
        if (this.store.selectSnapshot(state => state.language.localLanguage.is_rtl)) {
          document.getElementsByTagName('html')[0].setAttribute('dir', 'rtl');
          document.body.classList.add('ltr');
        } else {
          document.getElementsByTagName('html')[0].removeAttribute('dir');
          document.body.classList.remove('ltr');
        }
      },
    });

    this.router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {
        if (event.url === '/order/create') {
          this.navServices.collapseSidebar = true;
        }
      }
    });
  }
}
