import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { TranslatePipe } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { LanguageState } from '../../state/language.state';
import { LoaderState } from '../../state/loader.state';
import { Loader } from '../loader/loader';

@Component({
  selector: 'app-page-wrapper',
  imports: [CommonModule, Loader, TranslatePipe],
  templateUrl: './page-wrapper.html',
  styleUrls: ['./page-wrapper.scss'],
})
export class PageWrapper {
  private route = inject(ActivatedRoute);

  @Input() title: string;
  readonly grid = input<boolean>(true);
  readonly gridClass = input<string>('col-xxl-8 col-xl-10 m-auto');

  public lang: string;
  public isLang: boolean;

  loadingStatus$: Observable<boolean> = inject(Store).select(
    LoaderState.status,
  ) as Observable<boolean>;
  formLanguage$: Observable<string> = inject(Store).select(LanguageState.formLanguage);

  ngOnInit() {
    this.isLang = !!this.route.snapshot.paramMap.get('lang');
    this.lang = this.route.snapshot.paramMap.get('lang')!;
  }
}
