import { Component, Input, input, output } from '@angular/core';

@Component({
  selector: 'app-dropdown-list',
  templateUrl: './dropdown-list.html',
  styleUrls: ['./dropdown-list.scss'],
  imports: [],
})
export class DropdownList {
  @Input() data: any;
  readonly selectedPillIds = input<number[]>();
  readonly parentId = input<number[]>();
  readonly key = input<string>();
  readonly subArrayKey = input<string>();

  readonly selected = output<any>();
  readonly subItemClicked = output<any>();

  select(data: any) {
    data.selected = !data.selected;
    this.selected.emit(data);
  }

  onArrowClick(event: Event, data: any) {
    event.stopPropagation();
    this.subItemClicked.emit(data);
  }
}
