import { Component, Input, input, output, viewChild } from '@angular/core';

import { environment } from '../../../../../environments/environment';
import { IAttachment } from '../../../interface/attachment.interface';
import { MediaModal } from '../../ui/modal/media-modal/media-modal';

@Component({
  selector: 'app-image-upload',
  templateUrl: './image-upload.html',
  styleUrls: ['./image-upload.scss'],
  imports: [MediaModal],
})
export class ImageUpload {
  readonly MediaModal = viewChild<MediaModal>('mediaModal');

  @Input() images: IAttachment[] = [];
  @Input() image: IAttachment | null;
  readonly id = input<string>();
  @Input() imageUrl: string | null;
  readonly url = input<boolean>(false);
  readonly multipleImage = input<boolean>(false);
  @Input() helpText: string;
  readonly accept = input<any>();

  readonly selectedFiles = output<any>();

  public showImages: IAttachment[] = [];
  public showImage: IAttachment | null;
  public showImageUrl: String | null;
  public StorageURL = environment.storageURL;
  public mimeImageMapping: { mimeType: string; imagePath: string }[] = [
    { mimeType: 'application/pdf', imagePath: 'assets/images/pdf.png' },
    { mimeType: 'application/msword', imagePath: 'assets/images/word.png' },
    {
      mimeType: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
      imagePath: 'assets/images/word.png',
    },
    { mimeType: 'application/vnd.ms-excel', imagePath: 'assets/images/xls.png' },
    {
      mimeType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
      imagePath: 'assets/images/xls.png',
    },
    { mimeType: 'application/vnd.ms-powerpoint', imagePath: 'assets/images/folder.png' },
    {
      mimeType: 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
      imagePath: 'assets/images/folder.png',
    },
    { mimeType: 'text/plain', imagePath: 'assets/images/txt.png' },
    { mimeType: 'audio/mpeg', imagePath: 'assets/images/sound.png' },
    { mimeType: 'audio/wav', imagePath: 'assets/images/sound.png' },
    { mimeType: 'audio/ogg', imagePath: 'assets/images/sound.png' },
    { mimeType: 'video/mp4', imagePath: 'assets/images/video.png' },
    { mimeType: 'video/webm', imagePath: 'assets/images/video.png' },
    { mimeType: 'video/ogg', imagePath: 'assets/images/video.png' },
    { mimeType: 'application/zip', imagePath: 'assets/images/zip.png' },
    { mimeType: 'application/x-tar', imagePath: 'assets/images/zip.png' },
    { mimeType: 'application/gzip', imagePath: 'assets/images/zip.png' },
  ];

  ngOnChanges() {
    this.showImage = this.image;
    this.showImages = this.images;
    this.showImageUrl = this.imageUrl;
  }

  selectImage(data: IAttachment, url: boolean) {
    if (Array.isArray(data)) {
      this.images = data;
      this.showImages = data;
    } else if (url) {
      this.imageUrl = data.original_url;
      this.showImageUrl = data.original_url;
    } else {
      this.image = data;
      this.showImage = data;
    }

    if (this.imageUrl) {
      this.selectedFiles.emit(data.asset_url);
    } else {
      this.selectedFiles.emit(this.images.length ? this.images : this.image);
    }
  }

  remove(index: number, type: string) {
    if (type == 'multiple' && Array.isArray(this.images)) {
      this.images.splice(index, 1);
      this.showImages = this.images;
    } else if (type == 'single_image_url') {
      this.imageUrl = null;
      this.showImageUrl = null;
      this.image = null;
    } else {
      this.image = null;
      this.showImage = null;
    }
    this.selectedFiles.emit(this.images.length ? this.images : this.image);
  }

  getMimeTypeImage(mimeType: string) {
    return this.mimeImageMapping.find(value => value.mimeType == mimeType)?.imagePath;
  }
}
