import { AsyncPipe, CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { ActivatedRoute, RouterLink } from '@angular/router';

import { TranslatePipe } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { EditFormLanguageAction } from '../../../action/language.action';
import { ILanguageModel } from '../../../interface/language.interface';
import { IValues } from '../../../interface/setting.interface';
import { LanguageState } from '../../../state/language.state';
import { SettingState } from '../../../state/setting.state';

@Component({
  selector: 'app-language-redirection',
  imports: [CommonModule, AsyncPipe, FormsModule, RouterLink, TranslatePipe],
  templateUrl: './language-redirection.html',
  styleUrl: './language-redirection.scss',
})
export class LanguageRedirection {
  private store = inject(Store);
  private route = inject(ActivatedRoute);

  readonly path = input<string>();
  readonly id = input<number>();
  @Input() theme: string;

  public setting: IValues;
  public language: string;
  public isLang: boolean;

  setting$: Observable<IValues | null> = inject(Store).select(SettingState.setting);
  language$: Observable<ILanguageModel> = inject(Store).select(LanguageState.language);
  formLanguage$: Observable<string> = inject(Store).select(LanguageState.formLanguage);

  constructor() {
    this.isLang = !!this.route.snapshot.paramMap.get('lang');
    this.language = this.route.snapshot.paramMap.get('lang')!;

    this.setting$.subscribe(res => {
      this.setting = res!;
    });
  }

  ngOnDestroy() {
    this.store.dispatch(
      new EditFormLanguageAction(
        this.store.selectSnapshot(state => state.language.localLanguage.locale),
      ),
    );
  }
}
