import { Component, Input, TemplateRef, inject, input, viewChild } from '@angular/core';

import { NgbModal, ModalDismissReasons, NgbNavModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { NgxDropzoneChangeEvent, NgxDropzoneModule } from 'ngx-dropzone';

import { ImportAtributeAction } from '../../../../action/attribute.action';
import { ImportCategoryAction } from '../../../../action/category.action';
import { ImportProductAction } from '../../../../action/product.action';
import { ImportTagAction } from '../../../../action/tag.action';
import { ImportUserAction } from '../../../../action/user.action';
import { Button } from '../../button/button';

@Component({
  selector: 'app-import-csv-modal',
  imports: [Button, TranslateModule, NgbNavModule, NgxDropzoneModule],
  templateUrl: './import-csv-modal.html',
  styleUrls: ['./import-csv-modal.scss'],
})
export class ImportCsvModal {
  private store = inject(Store);
  private modalService = inject(NgbModal);

  public active = 'upload';
  public closeResult: string;
  public modalOpen: boolean = false;

  public files: File[] = [];

  @Input() module: string;
  readonly note = input<string>();

  readonly CSVModal = viewChild<TemplateRef<string>>('csvModal');

  async openModal() {
    this.modalOpen = true;
    this.modalService
      .open(this.CSVModal(), {
        ariaLabelledBy: 'Media-Modal',
        centered: true,
        windowClass: 'theme-modal modal-xl media-modal',
      })
      .result.then(
        result => {
          `Result ${result}`;
          this.closeResult = `Closed with: ${result}`;
        },
        reason => {
          this.closeResult = `Dismissed ${this.getDismissReason(reason)}`;
        },
      );
  }

  private getDismissReason(reason: ModalDismissReasons): string {
    this.active = 'upload';
    if (reason === ModalDismissReasons.ESC) {
      return 'by pressing ESC';
    } else if (reason === ModalDismissReasons.BACKDROP_CLICK) {
      return 'by clicking on a backdrop';
    } else {
      return `with: ${reason}`;
    }
  }

  onSelect(event: NgxDropzoneChangeEvent) {
    this.files.push(...event.addedFiles);
  }

  onRemove(event: File) {
    this.files.splice(this.files.indexOf(event), 1);
  }

  upload() {
    if (this.files.length && this.module) {
      let action = new ImportUserAction(this.files);
      if (this.module == 'user') {
        action = new ImportUserAction(this.files);
      } else if (this.module == 'product') {
        action = new ImportProductAction(this.files);
      } else if (this.module == 'attribute') {
        action = new ImportAtributeAction(this.files);
      } else if (this.module == 'category') {
        action = new ImportCategoryAction(this.files);
      } else if (this.module == 'tag') {
        action = new ImportTagAction(this.files);
      }
      this.store.dispatch(action).subscribe({
        complete: () => {
          this.files = [];
          this.modalService.dismissAll();
        },
      });
    }
  }

  ngOnDestroy() {
    if (this.modalOpen) {
      this.modalService.dismissAll();
    }
  }
}
