import { AsyncPipe } from '@angular/common';
import { Component, inject, input } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { IValues } from '../../../../../interface/setting.interface';
import { SettingState } from '../../../../../state/setting.state';

@Component({
  selector: 'app-sidebar-menu-skeleton',
  imports: [AsyncPipe],
  templateUrl: './sidebar-menu-skeleton.html',
  styleUrls: ['./sidebar-menu-skeleton.scss'],
})
export class SidebarMenuSkeleton {
  readonly loading = input<boolean>(false);

  setting$: Observable<IValues | null> = inject(Store).select(SettingState.setting);

  public skeletonItems = Array.from({ length: 20 }, (_, index) => index);
}
