import { Component, inject, Input, viewChild } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { AddToCartAction } from '../../../action/cart.action';
import { ICartAddOrUpdate } from '../../../interface/cart.interface';
import { IProduct } from '../../../interface/product.interface';
import { IValues } from '../../../interface/setting.interface';
import { CurrencySymbolPipe } from '../../../pipe/currency-symbol.pipe';
import { SettingState } from '../../../state/setting.state';
import { Button } from '../button/button';
import { Addtocart } from './modal/addtocart/addtocart';

@Component({
  selector: 'app-product-box',
  templateUrl: './product-box.html',
  styleUrls: ['./product-box.scss'],
  imports: [Button, Addtocart, TranslateModule, CurrencySymbolPipe],
})
export class ProductBox {
  private store = inject(Store);

  @Input() product: IProduct;

  readonly addToCartModal = viewChild<Addtocart>('addToCartModal');

  setting$: Observable<IValues> = inject(Store).select(SettingState.setting) as Observable<IValues>;

  public cartItems: ICartAddOrUpdate;
  public url: string;

  constructor() {
    this.setting$.subscribe(setting => {
      this.url = setting.general.site_url;
    });
  }

  addToCart(product: IProduct, qty: number) {
    const params: ICartAddOrUpdate = {
      product_id: product?.id,
      variation_id: '',
      quantity: qty,
    };
    this.store.dispatch(new AddToCartAction(params));
  }

  externalProductLink(link: string) {
    if (link) {
      window.open(link, '_blank');
    }
  }
}
