import { AsyncPipe } from '@angular/common';
import { Component, inject, Input } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { IValues } from '../../../../interface/setting.interface';
import { SettingState } from '../../../../state/setting.state';

@Component({
  selector: 'app-sidebar-menu-skeleton',
  templateUrl: './sidebar-menu-skeleton.html',
  styleUrls: ['./sidebar-menu-skeleton.scss'],
  standalone: true,
  imports: [AsyncPipe],
})
export class SidebarMenuSkeleton {
  @Input() loading: boolean = false;

  setting$: Observable<IValues> = inject(Store).select(SettingState.setting) as Observable<IValues>;

  public skeletonItems = Array.from({ length: 20 }, (_, index) => index);
}
