import { IAttachment } from './attachment.interface';
import { IPaginateModel } from './core.interface';
import { ICountry } from './country.interface';
import { IStates } from './state.interface';

export interface IAuthorModel extends IPaginateModel {
  data: IAuthor[];
}

export interface IAuthor {
  id: number;
  author_name: string;
  bio: string;
  slug: string;
  author_image_id: number;
  author_image: IAttachment;
  author_cover_image_id: number;
  author_cover_image: IAttachment;
  country_id: number;
  state_id: number;
  city: string;
  birth_date: string;
  death_date: string;
  languages: string;
  facebook: string;
  twitter: string;
  instagram: string;
  youtube: string;
  pinterest: string;
  country: ICountry;
  state: IStates;
  status: boolean;
  created_by_id: number;
  created_at?: string;
  updated_at?: string;
  deleted_at?: string;
}
