import { IPaginateModel } from './core.interface';

export interface IReportsCouponModel extends IPaginateModel {
  data: IReportsCoupon[];
}

export interface IReportsProductModel extends IPaginateModel {
  data: IReportsProduct[];
}

export interface IReportsCoupon {
  id: number;
  code: string;
  type: string;
  amount: string;
  title: string;
  description: string;
  usage_count: number;
  exclude_products_count: number;
  usage_sum_coupon_total_discount: number;
}

export interface IReportsProduct {
  name: string;
  num_of_sales: number;
  vendor: string;
  price: number;
  sale_price: number;
  discount: number;
  order_count: number;
}

export interface IReports {
  title: string;
  field_type: string;
  show_fields_table: string[];
}
