export interface ITableConfig {
  columns?: ITableColumn[];
  rowActions?: ITableAction[];
  data?: any[];
  total?: number;
  permission?: string | string[];
  search?: boolean;
}

export interface ITableColumn {
  title?: string | undefined;
  dataField?: string;
  key?: string;
  sortable?: boolean;
  sort_direction?: string;
  type?: string;
  canAllow?: string[];
  date_format?: string;
  class?: string;
  placeholder?: string;
}

export interface ITableAction {
  label: string;
  actionToPerform: string;
  icon: string;
  permission?: string | string[];
  conditional?: IConditional;
}

export interface ITableClickedAction {
  actionToPerform?: string;
  data?: any;
  value?: any;
}

export interface IConditional {
  field: string;
  condition: string;
  value: string;
}
