import { inject } from '@angular/core';
import { ResolveFn } from '@angular/router';

import { Store } from '@ngxs/store';
import { map } from 'rxjs/operators';

import { GetSettingOptionAction } from '../action/setting.action';

export const SettingResolver: ResolveFn<boolean> = (_route, _state) => {
  return inject(Store)
    .dispatch(new GetSettingOptionAction())
    .pipe(
      map(() => true), // Convert the Observable<void> to Observable<boolean>
    );
};
