import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IAccountUser, IAccountUserUpdatePassword } from '../interface/account.interface';
import { IStores } from '../interface/store.interface';

@Injectable({
  providedIn: 'root',
})
export class AccountService {
  private http = inject(HttpClient);

  getUserDetails(): Observable<IAccountUser> {
    return this.http.get<IAccountUser>(`${environment.URL}/self`);
  }

  updateProfile(payload: IAccountUser): Observable<IAccountUser> {
    return this.http.put<IAccountUser>(`${environment.URL}/updateProfile`, payload);
  }

  updatePassword(payload: IAccountUserUpdatePassword): Observable<IAccountUserUpdatePassword> {
    return this.http.put<IAccountUserUpdatePassword>(`${environment.URL}/updatePassword`, payload);
  }

  updateStore(payload: IStores): Observable<IStores> {
    return this.http.put<IStores>(`${environment.URL}/updateStoreProfile`, payload);
  }
}
