import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IAttachment, IAttachmentModel } from '../interface/attachment.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class AttachmentService {
  private http = inject(HttpClient);

  getAttachments(payload?: Params): Observable<IAttachmentModel> {
    return this.http.get<IAttachmentModel>(`${environment.URL}/attachment`, { params: payload });
  }

  createAttachment(payload: File[]): Observable<IAttachment> {
    let form = new FormData();
    if (Array.isArray(payload) && payload.length) {
      payload.forEach((element: File, index: number) => {
        form.append(`attachments[${index}]`, element, element.name);
      });
    }
    return this.http.post<IAttachment>(`${environment.URL}/attachment`, form);
  }

  deleteAttachment(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/attachment/${id}`);
  }

  deleteAllAttachment(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/attachment/deleteAll`, { ids: ids });
  }
}
